/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskRunLevel
extends PeerCompatibleTask {
    private List<Integer> m_reqLevels = new ArrayList<Integer>();
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1064", false);

    public TaskRunLevel(int currLevel, int reqLevel) {
        this.m_reqLevels.add(reqLevel);
    }

    public TaskRunLevel(int reqLevel) {
        this.m_reqLevels.add(reqLevel);
    }

    public TaskRunLevel(List<Integer> reqLevels) {
        this.m_reqLevels.addAll(reqLevels);
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet runLvlRsltSet = new ResultSet();
        FixupData fixupData = null;
        if (this.isFixupReqd()) {
            fixupData = new FixupData(null);
        }
        globalExec.checkRunlevel(this.m_nodeList, -1, runLvlRsltSet);
        this.m_resultSet.uploadResultSet(runLvlRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.RUNLEVEL, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable t = runLvlRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String nstatus;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(VerificationUtil.strCollection2String(this.m_reqLevels));
                this.m_resultSet.getResult(node).setActualValue(avl);
                boolean match = false;
                for (Integer requiredRunLevel : this.m_reqLevels) {
                    if (!String.valueOf(requiredRunLevel).equals(avl)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    nstatus = ReportUtil.PASSED;
                } else {
                    nstatus = ReportUtil.FAILED;
                    errDesc = new ErrorDescription("7564", new String[]{node, VerificationUtil.strCollection2String(this.m_reqLevels)}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 3);
                    if (null != fixupData) {
                        this.setRebootRequiredForFixup(true);
                        String expectedRunlevelValue = Integer.toString(this.m_reqLevels.get(0));
                        Trace.out((String)("Generating fixup data for run level Expected Value (" + expectedRunlevelValue + ") on node '" + node + "'"));
                        VerificationLogData.logInfo("Generating fixup data for run level Expected Value (" + expectedRunlevelValue + ") on node '" + node + "'");
                        fixupData.addParticipatingNode(node);
                        fixupData.setExpectedValue(node, expectedRunlevelValue);
                    }
                }
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7565", false, (Object[])new String[]{node}), s_msgBundle.getCause("7565", false), s_msgBundle.getAction("7565", false));
                nstatus = ReportUtil.FAILED;
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, avl, VerificationUtil.strCollection2String(this.m_reqLevels), nstatus);
        }
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0310", false, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_reqLevels)}));
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        if (null != fixupData && !this.isFixupDataSet()) {
            Trace.out((String)("Adding the generated fixup data for run level (" + Integer.toString(this.m_reqLevels.get(0)) + ")"));
            VerificationLogData.logInfo("Adding the generated fixup data for run level (" + Integer.toString(this.m_reqLevels.get(0)) + ")");
            this.setFixupData(fixupData);
        }
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0311", false, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_reqLevels), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet runLevelRS = new ResultSet();
        globalExec.checkRunlevel(this.m_nodeList, -1, runLevelRS);
        Hashtable ht = runLevelRS.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() != 3) continue;
            result.setStatus(1);
        }
        return runLevelRS;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1064", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4418", false);
    }

    @Override
    public String getTaskID() {
        return "RUN_LEVEL";
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4469", false);
    }
}

